package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  FeatureGroupArn,
  LastModifiedTime,
  FeatureGroupName,
  FeatureName,
  FeatureDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeFeatureMetadataResponse(
    featureGroupArn: FeatureGroupArn,
    featureGroupName: FeatureGroupName,
    featureName: FeatureName,
    featureType: zio.aws.sagemaker.model.FeatureType,
    creationTime: CreationTime,
    lastModifiedTime: LastModifiedTime,
    description: Optional[FeatureDescription] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.sagemaker.model.FeatureParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse = {
    import DescribeFeatureMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse
      .builder()
      .featureGroupArn(
        FeatureGroupArn.unwrap(featureGroupArn): java.lang.String
      )
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .featureName(FeatureName.unwrap(featureName): java.lang.String)
      .featureType(featureType.unwrap)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .lastModifiedTime(LastModifiedTime.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        description.map(value =>
          FeatureDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFeatureMetadataResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeFeatureMetadataResponse
      .wrap(buildAwsValue())
}
object DescribeFeatureMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFeatureMetadataResponse =
      zio.aws.sagemaker.model.DescribeFeatureMetadataResponse(
        featureGroupArn,
        featureGroupName,
        featureName,
        featureType,
        creationTime,
        lastModifiedTime,
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureGroupArn: FeatureGroupArn
    def featureGroupName: FeatureGroupName
    def featureName: FeatureName
    def featureType: zio.aws.sagemaker.model.FeatureType
    def creationTime: CreationTime
    def lastModifiedTime: LastModifiedTime
    def description: Optional[FeatureDescription]
    def parameters
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]]
    def getFeatureGroupArn: ZIO[Any, Nothing, FeatureGroupArn] =
      ZIO.succeed(featureGroupArn)
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
    def getFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(featureName)
    def getFeatureType: ZIO[Any, Nothing, zio.aws.sagemaker.model.FeatureType] =
      ZIO.succeed(featureType)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, LastModifiedTime] =
      ZIO.succeed(lastModifiedTime)
    def getDescription: ZIO[Any, AwsError, FeatureDescription] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse
  ) extends zio.aws.sagemaker.model.DescribeFeatureMetadataResponse.ReadOnly {
    override val featureGroupArn: FeatureGroupArn =
      zio.aws.sagemaker.model.primitives.FeatureGroupArn(impl.featureGroupArn())
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
    override val featureName: FeatureName =
      zio.aws.sagemaker.model.primitives.FeatureName(impl.featureName())
    override val featureType: zio.aws.sagemaker.model.FeatureType =
      zio.aws.sagemaker.model.FeatureType.wrap(impl.featureType())
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val lastModifiedTime: LastModifiedTime =
      zio.aws.sagemaker.model.primitives
        .LastModifiedTime(impl.lastModifiedTime())
    override val description: Optional[FeatureDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureDescription(value)
        )
    override val parameters
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse
  ): zio.aws.sagemaker.model.DescribeFeatureMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
