package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AutoMLJobName
import scala.jdk.CollectionConverters._
final case class DescribeAutoMlJobV2Request(autoMLJobName: AutoMLJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request = {
    import DescribeAutoMlJobV2Request.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAutoMlJobV2Request.ReadOnly =
    zio.aws.sagemaker.model.DescribeAutoMlJobV2Request.wrap(buildAwsValue())
}
object DescribeAutoMlJobV2Request {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAutoMlJobV2Request =
      zio.aws.sagemaker.model.DescribeAutoMlJobV2Request(autoMLJobName)
    def autoMLJobName: AutoMLJobName
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request
  ) extends zio.aws.sagemaker.model.DescribeAutoMlJobV2Request.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request
  ): zio.aws.sagemaker.model.DescribeAutoMlJobV2Request.ReadOnly = new Wrapper(
    impl
  )
}
