package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.DataInputConfig
import scala.jdk.CollectionConverters._
final case class DerivedInformation(
    derivedDataInputConfig: Optional[DataInputConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DerivedInformation = {
    import DerivedInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DerivedInformation
      .builder()
      .optionallyWith(
        derivedDataInputConfig.map(value =>
          DataInputConfig.unwrap(value): java.lang.String
        )
      )(_.derivedDataInputConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DerivedInformation.ReadOnly =
    zio.aws.sagemaker.model.DerivedInformation.wrap(buildAwsValue())
}
object DerivedInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DerivedInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DerivedInformation =
      zio.aws.sagemaker.model
        .DerivedInformation(derivedDataInputConfig.map(value => value))
    def derivedDataInputConfig: Optional[DataInputConfig]
    def getDerivedDataInputConfig: ZIO[Any, AwsError, DataInputConfig] =
      AwsError.unwrapOptionField(
        "derivedDataInputConfig",
        derivedDataInputConfig
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DerivedInformation
  ) extends zio.aws.sagemaker.model.DerivedInformation.ReadOnly {
    override val derivedDataInputConfig: Optional[DataInputConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.derivedDataInputConfig())
        .map(value => zio.aws.sagemaker.model.primitives.DataInputConfig(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DerivedInformation
  ): zio.aws.sagemaker.model.DerivedInformation.ReadOnly = new Wrapper(impl)
}
