package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName
import scala.jdk.CollectionConverters._
final case class CreateHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    hyperParameterTuningJobConfig: zio.aws.sagemaker.model.HyperParameterTuningJobConfig,
    trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
    ] = Optional.Absent,
    trainingJobDefinitions: Optional[
      Iterable[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition]
    ] = Optional.Absent,
    warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    autotune: Optional[zio.aws.sagemaker.model.Autotune] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest = {
    import CreateHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .hyperParameterTuningJobConfig(
        hyperParameterTuningJobConfig.buildAwsValue()
      )
      .optionallyWith(
        trainingJobDefinition.map(value => value.buildAwsValue())
      )(_.trainingJobDefinition)
      .optionallyWith(
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trainingJobDefinitions)
      .optionallyWith(warmStartConfig.map(value => value.buildAwsValue()))(
        _.warmStartConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(autotune.map(value => value.buildAwsValue()))(_.autotune)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object CreateHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest(
        hyperParameterTuningJobName,
        hyperParameterTuningJobConfig.asEditable,
        trainingJobDefinition.map(value => value.asEditable),
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warmStartConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autotune.map(value => value.asEditable)
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    def trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]
    def trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ]
    def warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def autotune: Optional[zio.aws.sagemaker.model.Autotune.ReadOnly]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getHyperParameterTuningJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ] = ZIO.succeed(hyperParameterTuningJobConfig)
    def getTrainingJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] =
      AwsError.unwrapOptionField("trainingJobDefinition", trainingJobDefinition)
    def getTrainingJobDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trainingJobDefinitions",
      trainingJobDefinitions
    )
    def getWarmStartConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField("warmStartConfig", warmStartConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAutotune
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Autotune.ReadOnly] =
      AwsError.unwrapOptionField("autotune", autotune)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly =
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig
        .wrap(impl.hyperParameterTuningJobConfig())
    override val trainingJobDefinition: Optional[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinition())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(value)
      )
    override val trainingJobDefinitions: Optional[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingJobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(item)
        }.toList
      )
    override val warmStartConfig: Optional[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warmStartConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
          .wrap(value)
      )
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val autotune: Optional[zio.aws.sagemaker.model.Autotune.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autotune())
        .map(value => zio.aws.sagemaker.model.Autotune.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
