package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EdgeDeploymentPlanArn
import scala.jdk.CollectionConverters._
final case class CreateEdgeDeploymentPlanResponse(
    edgeDeploymentPlanArn: EdgeDeploymentPlanArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse = {
    import CreateEdgeDeploymentPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse
      .builder()
      .edgeDeploymentPlanArn(
        EdgeDeploymentPlanArn.unwrap(edgeDeploymentPlanArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse
      .wrap(buildAwsValue())
}
object CreateEdgeDeploymentPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse =
      zio.aws.sagemaker.model
        .CreateEdgeDeploymentPlanResponse(edgeDeploymentPlanArn)
    def edgeDeploymentPlanArn: EdgeDeploymentPlanArn
    def getEdgeDeploymentPlanArn: ZIO[Any, Nothing, EdgeDeploymentPlanArn] =
      ZIO.succeed(edgeDeploymentPlanArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse
  ) extends zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse.ReadOnly {
    override val edgeDeploymentPlanArn: EdgeDeploymentPlanArn =
      zio.aws.sagemaker.model.primitives
        .EdgeDeploymentPlanArn(impl.edgeDeploymentPlanArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse
  ): zio.aws.sagemaker.model.CreateEdgeDeploymentPlanResponse.ReadOnly =
    new Wrapper(impl)
}
