package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConvergenceDetected(
    completeOnConvergence: Optional[
      zio.aws.sagemaker.model.CompleteOnConvergence
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected = {
    import ConvergenceDetected.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected
      .builder()
      .optionallyWith(completeOnConvergence.map(value => value.unwrap))(
        _.completeOnConvergence
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly =
    zio.aws.sagemaker.model.ConvergenceDetected.wrap(buildAwsValue())
}
object ConvergenceDetected {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ConvergenceDetected =
      zio.aws.sagemaker.model
        .ConvergenceDetected(completeOnConvergence.map(value => value))
    def completeOnConvergence
        : Optional[zio.aws.sagemaker.model.CompleteOnConvergence]
    def getCompleteOnConvergence
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompleteOnConvergence] =
      AwsError.unwrapOptionField("completeOnConvergence", completeOnConvergence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected
  ) extends zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly {
    override val completeOnConvergence
        : Optional[zio.aws.sagemaker.model.CompleteOnConvergence] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completeOnConvergence())
        .map(value => zio.aws.sagemaker.model.CompleteOnConvergence.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ConvergenceDetected
  ): zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly = new Wrapper(impl)
}
