package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CompilationJobStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus
}
object CompilationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus
  ): zio.aws.sagemaker.model.CompilationJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.INPROGRESS =>
      val r = INPROGRESS
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INPROGRESS extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.INPROGRESS
  }
  case object COMPLETED extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.FAILED
  }
  case object STARTING extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STARTING
  }
  case object STOPPING extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STOPPING
  }
  case object STOPPED extends zio.aws.sagemaker.model.CompilationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus =
      software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus.STOPPED
  }
}
