package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CandidateGenerationConfig(
    algorithmsConfig: Optional[
      Iterable[zio.aws.sagemaker.model.AutoMLAlgorithmConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig = {
    import CandidateGenerationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig
      .builder()
      .optionallyWith(
        algorithmsConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.algorithmsConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly =
    zio.aws.sagemaker.model.CandidateGenerationConfig.wrap(buildAwsValue())
}
object CandidateGenerationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CandidateGenerationConfig =
      zio.aws.sagemaker.model.CandidateGenerationConfig(
        algorithmsConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def algorithmsConfig
        : Optional[List[zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly]]
    def getAlgorithmsConfig: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("algorithmsConfig", algorithmsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig
  ) extends zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly {
    override val algorithmsConfig: Optional[
      List[zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmsConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLAlgorithmConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateGenerationConfig
  ): zio.aws.sagemaker.model.CandidateGenerationConfig.ReadOnly = new Wrapper(
    impl
  )
}
