package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class AutoMLCandidateGenerationConfig(
    featureSpecificationS3Uri: Optional[S3Uri] = Optional.Absent,
    algorithmsConfig: Optional[
      Iterable[zio.aws.sagemaker.model.AutoMLAlgorithmConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig = {
    import AutoMLCandidateGenerationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
      .builder()
      .optionallyWith(
        featureSpecificationS3Uri.map(value =>
          S3Uri.unwrap(value): java.lang.String
        )
      )(_.featureSpecificationS3Uri)
      .optionallyWith(
        algorithmsConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.algorithmsConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly =
    zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig
      .wrap(buildAwsValue())
}
object AutoMLCandidateGenerationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig =
      zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig(
        featureSpecificationS3Uri.map(value => value),
        algorithmsConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureSpecificationS3Uri: Optional[S3Uri]
    def algorithmsConfig
        : Optional[List[zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly]]
    def getFeatureSpecificationS3Uri: ZIO[Any, AwsError, S3Uri] = AwsError
      .unwrapOptionField("featureSpecificationS3Uri", featureSpecificationS3Uri)
    def getAlgorithmsConfig: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("algorithmsConfig", algorithmsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ) extends zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly {
    override val featureSpecificationS3Uri: Optional[S3Uri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureSpecificationS3Uri())
        .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val algorithmsConfig: Optional[
      List[zio.aws.sagemaker.model.AutoMLAlgorithmConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.algorithmsConfig())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLAlgorithmConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLCandidateGenerationConfig
  ): zio.aws.sagemaker.model.AutoMLCandidateGenerationConfig.ReadOnly =
    new Wrapper(impl)
}
