package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait VariantStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.VariantStatus
}
object VariantStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.VariantStatus
  ): zio.aws.sagemaker.model.VariantStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.CREATING =>
      val r = Creating
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.UPDATING =>
      val r = Updating
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.ACTIVATING_TRAFFIC =>
      val r = ActivatingTraffic
      r
    case software.amazon.awssdk.services.sagemaker.model.VariantStatus.BAKING =>
      val r = Baking
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Creating extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.CREATING
  }
  case object Updating extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.UPDATING
  }
  case object Deleting extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.DELETING
  }
  case object ActivatingTraffic extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.ACTIVATING_TRAFFIC
  }
  case object Baking extends zio.aws.sagemaker.model.VariantStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.VariantStatus =
      software.amazon.awssdk.services.sagemaker.model.VariantStatus.BAKING
  }
}
