package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  LastModifiedTime,
  CreationTime,
  UserProfileName,
  DomainId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UserProfileDetails(
    domainId: Optional[DomainId] = Optional.Absent,
    userProfileName: Optional[UserProfileName] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.UserProfileStatus] =
      Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UserProfileDetails = {
    import UserProfileDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UserProfileDetails
      .builder()
      .optionallyWith(
        domainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UserProfileDetails.ReadOnly =
    zio.aws.sagemaker.model.UserProfileDetails.wrap(buildAwsValue())
}
object UserProfileDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UserProfileDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UserProfileDetails =
      zio.aws.sagemaker.model.UserProfileDetails(
        domainId.map(value => value),
        userProfileName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def domainId: Optional[DomainId]
    def userProfileName: Optional[UserProfileName]
    def status: Optional[zio.aws.sagemaker.model.UserProfileStatus]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def getDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserProfileStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UserProfileDetails
  ) extends zio.aws.sagemaker.model.UserProfileDetails.ReadOnly {
    override val domainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainId())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileName: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileName())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val status: Optional[zio.aws.sagemaker.model.UserProfileStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.UserProfileStatus.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UserProfileDetails
  ): zio.aws.sagemaker.model.UserProfileDetails.ReadOnly = new Wrapper(impl)
}
