package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{ModelCardContent, ModelCardNameOrArn}
import scala.jdk.CollectionConverters._
final case class UpdateModelCardRequest(
    modelCardName: ModelCardNameOrArn,
    content: Optional[ModelCardContent] = Optional.Absent,
    modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest = {
    import UpdateModelCardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest
      .builder()
      .modelCardName(ModelCardNameOrArn.unwrap(modelCardName): java.lang.String)
      .optionallyWith(
        content.map(value => ModelCardContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(modelCardStatus.map(value => value.unwrap))(
        _.modelCardStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateModelCardRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateModelCardRequest.wrap(buildAwsValue())
}
object UpdateModelCardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateModelCardRequest =
      zio.aws.sagemaker.model.UpdateModelCardRequest(
        modelCardName,
        content.map(value => value),
        modelCardStatus.map(value => value)
      )
    def modelCardName: ModelCardNameOrArn
    def content: Optional[ModelCardContent]
    def modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus]
    def getModelCardName: ZIO[Any, Nothing, ModelCardNameOrArn] =
      ZIO.succeed(modelCardName)
    def getContent: ZIO[Any, AwsError, ModelCardContent] =
      AwsError.unwrapOptionField("content", content)
    def getModelCardStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardStatus] =
      AwsError.unwrapOptionField("modelCardStatus", modelCardStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest
  ) extends zio.aws.sagemaker.model.UpdateModelCardRequest.ReadOnly {
    override val modelCardName: ModelCardNameOrArn =
      zio.aws.sagemaker.model.primitives
        .ModelCardNameOrArn(impl.modelCardName())
    override val content: Optional[ModelCardContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.sagemaker.model.primitives.ModelCardContent(value))
    override val modelCardStatus
        : Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardStatus())
        .map(value => zio.aws.sagemaker.model.ModelCardStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest
  ): zio.aws.sagemaker.model.UpdateModelCardRequest.ReadOnly = new Wrapper(impl)
}
