package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class UpdateDevicesRequest(
    deviceFleetName: EntityName,
    devices: Iterable[zio.aws.sagemaker.model.Device]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest = {
    import UpdateDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .devices(devices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateDevicesRequest.wrap(buildAwsValue())
}
object UpdateDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateDevicesRequest =
      zio.aws.sagemaker.model.UpdateDevicesRequest(
        deviceFleetName,
        devices.map { item =>
          item.asEditable
        }
      )
    def deviceFleetName: EntityName
    def devices: List[zio.aws.sagemaker.model.Device.ReadOnly]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getDevices
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Device.ReadOnly]] =
      ZIO.succeed(devices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest
  ) extends zio.aws.sagemaker.model.UpdateDevicesRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val devices: List[zio.aws.sagemaker.model.Device.ReadOnly] = impl
      .devices()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.Device.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest
  ): zio.aws.sagemaker.model.UpdateDevicesRequest.ReadOnly = new Wrapper(impl)
}
