package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.TargetObjectiveMetricValue
import scala.jdk.CollectionConverters._
final case class TuningJobCompletionCriteria(
    targetObjectiveMetricValue: Optional[TargetObjectiveMetricValue] =
      Optional.Absent,
    bestObjectiveNotImproving: Optional[
      zio.aws.sagemaker.model.BestObjectiveNotImproving
    ] = Optional.Absent,
    convergenceDetected: Optional[zio.aws.sagemaker.model.ConvergenceDetected] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria = {
    import TuningJobCompletionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
      .builder()
      .optionallyWith(
        targetObjectiveMetricValue.map(value =>
          TargetObjectiveMetricValue.unwrap(value): java.lang.Float
        )
      )(_.targetObjectiveMetricValue)
      .optionallyWith(
        bestObjectiveNotImproving.map(value => value.buildAwsValue())
      )(_.bestObjectiveNotImproving)
      .optionallyWith(convergenceDetected.map(value => value.buildAwsValue()))(
        _.convergenceDetected
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly =
    zio.aws.sagemaker.model.TuningJobCompletionCriteria.wrap(buildAwsValue())
}
object TuningJobCompletionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TuningJobCompletionCriteria =
      zio.aws.sagemaker.model.TuningJobCompletionCriteria(
        targetObjectiveMetricValue.map(value => value),
        bestObjectiveNotImproving.map(value => value.asEditable),
        convergenceDetected.map(value => value.asEditable)
      )
    def targetObjectiveMetricValue: Optional[TargetObjectiveMetricValue]
    def bestObjectiveNotImproving
        : Optional[zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly]
    def convergenceDetected
        : Optional[zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly]
    def getTargetObjectiveMetricValue
        : ZIO[Any, AwsError, TargetObjectiveMetricValue] =
      AwsError.unwrapOptionField(
        "targetObjectiveMetricValue",
        targetObjectiveMetricValue
      )
    def getBestObjectiveNotImproving: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bestObjectiveNotImproving",
      bestObjectiveNotImproving
    )
    def getConvergenceDetected: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly
    ] = AwsError.unwrapOptionField("convergenceDetected", convergenceDetected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ) extends zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly {
    override val targetObjectiveMetricValue
        : Optional[TargetObjectiveMetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.targetObjectiveMetricValue())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TargetObjectiveMetricValue(value)
      )
    override val bestObjectiveNotImproving
        : Optional[zio.aws.sagemaker.model.BestObjectiveNotImproving.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bestObjectiveNotImproving())
        .map(value =>
          zio.aws.sagemaker.model.BestObjectiveNotImproving.wrap(value)
        )
    override val convergenceDetected
        : Optional[zio.aws.sagemaker.model.ConvergenceDetected.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.convergenceDetected())
        .map(value => zio.aws.sagemaker.model.ConvergenceDetected.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TuningJobCompletionCriteria
  ): zio.aws.sagemaker.model.TuningJobCompletionCriteria.ReadOnly = new Wrapper(
    impl
  )
}
