package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{TargetLabelColumn, ContentColumn}
import scala.jdk.CollectionConverters._
final case class TextClassificationJobConfig(
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    contentColumn: ContentColumn,
    targetLabelColumn: TargetLabelColumn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig = {
    import TextClassificationJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .contentColumn(ContentColumn.unwrap(contentColumn): java.lang.String)
      .targetLabelColumn(
        TargetLabelColumn.unwrap(targetLabelColumn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly =
    zio.aws.sagemaker.model.TextClassificationJobConfig.wrap(buildAwsValue())
}
object TextClassificationJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TextClassificationJobConfig =
      zio.aws.sagemaker.model.TextClassificationJobConfig(
        completionCriteria.map(value => value.asEditable),
        contentColumn,
        targetLabelColumn
      )
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def contentColumn: ContentColumn
    def targetLabelColumn: TargetLabelColumn
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getContentColumn: ZIO[Any, Nothing, ContentColumn] =
      ZIO.succeed(contentColumn)
    def getTargetLabelColumn: ZIO[Any, Nothing, TargetLabelColumn] =
      ZIO.succeed(targetLabelColumn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ) extends zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly {
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val contentColumn: ContentColumn =
      zio.aws.sagemaker.model.primitives.ContentColumn(impl.contentColumn())
    override val targetLabelColumn: TargetLabelColumn =
      zio.aws.sagemaker.model.primitives
        .TargetLabelColumn(impl.targetLabelColumn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TextClassificationJobConfig
  ): zio.aws.sagemaker.model.TextClassificationJobConfig.ReadOnly = new Wrapper(
    impl
  )
}
