package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  ResourcePropertyName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchRequest(
    resource: zio.aws.sagemaker.model.ResourceType,
    searchExpression: Optional[zio.aws.sagemaker.model.SearchExpression] =
      Optional.Absent,
    sortBy: Optional[ResourcePropertyName] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SearchSortOrder] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    crossAccountFilterOption: Optional[
      zio.aws.sagemaker.model.CrossAccountFilterOption
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SearchRequest = {
    import SearchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SearchRequest
      .builder()
      .resource(resource.unwrap)
      .optionallyWith(searchExpression.map(value => value.buildAwsValue()))(
        _.searchExpression
      )
      .optionallyWith(
        sortBy.map(value =>
          ResourcePropertyName.unwrap(value): java.lang.String
        )
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(crossAccountFilterOption.map(value => value.unwrap))(
        _.crossAccountFilterOption
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SearchRequest.ReadOnly =
    zio.aws.sagemaker.model.SearchRequest.wrap(buildAwsValue())
}
object SearchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SearchRequest =
      zio.aws.sagemaker.model.SearchRequest(
        resource,
        searchExpression.map(value => value.asEditable),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        crossAccountFilterOption.map(value => value)
      )
    def resource: zio.aws.sagemaker.model.ResourceType
    def searchExpression
        : Optional[zio.aws.sagemaker.model.SearchExpression.ReadOnly]
    def sortBy: Optional[ResourcePropertyName]
    def sortOrder: Optional[zio.aws.sagemaker.model.SearchSortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def crossAccountFilterOption
        : Optional[zio.aws.sagemaker.model.CrossAccountFilterOption]
    def getResource: ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceType] =
      ZIO.succeed(resource)
    def getSearchExpression: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SearchExpression.ReadOnly
    ] = AwsError.unwrapOptionField("searchExpression", searchExpression)
    def getSortBy: ZIO[Any, AwsError, ResourcePropertyName] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SearchSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCrossAccountFilterOption
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CrossAccountFilterOption] =
      AwsError.unwrapOptionField(
        "crossAccountFilterOption",
        crossAccountFilterOption
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ) extends zio.aws.sagemaker.model.SearchRequest.ReadOnly {
    override val resource: zio.aws.sagemaker.model.ResourceType =
      zio.aws.sagemaker.model.ResourceType.wrap(impl.resource())
    override val searchExpression
        : Optional[zio.aws.sagemaker.model.SearchExpression.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.searchExpression())
        .map(value => zio.aws.sagemaker.model.SearchExpression.wrap(value))
    override val sortBy: Optional[ResourcePropertyName] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ResourcePropertyName(value)
      )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SearchSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SearchSortOrder.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val crossAccountFilterOption
        : Optional[zio.aws.sagemaker.model.CrossAccountFilterOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossAccountFilterOption())
        .map(value =>
          zio.aws.sagemaker.model.CrossAccountFilterOption.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SearchRequest
  ): zio.aws.sagemaker.model.SearchRequest.ReadOnly = new Wrapper(impl)
}
