package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ScheduleExpression
import scala.jdk.CollectionConverters._
final case class ScheduleConfig(
    scheduleExpression: ScheduleExpression,
    dataAnalysisStartTime: Optional[String] = Optional.Absent,
    dataAnalysisEndTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ScheduleConfig = {
    import ScheduleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
      .builder()
      .scheduleExpression(
        ScheduleExpression.unwrap(scheduleExpression): java.lang.String
      )
      .optionallyWith(
        dataAnalysisStartTime.map(value => value: java.lang.String)
      )(_.dataAnalysisStartTime)
      .optionallyWith(
        dataAnalysisEndTime.map(value => value: java.lang.String)
      )(_.dataAnalysisEndTime)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ScheduleConfig.ReadOnly =
    zio.aws.sagemaker.model.ScheduleConfig.wrap(buildAwsValue())
}
object ScheduleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ScheduleConfig =
      zio.aws.sagemaker.model.ScheduleConfig(
        scheduleExpression,
        dataAnalysisStartTime.map(value => value),
        dataAnalysisEndTime.map(value => value)
      )
    def scheduleExpression: ScheduleExpression
    def dataAnalysisStartTime: Optional[String]
    def dataAnalysisEndTime: Optional[String]
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpression] =
      ZIO.succeed(scheduleExpression)
    def getDataAnalysisStartTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataAnalysisStartTime", dataAnalysisStartTime)
    def getDataAnalysisEndTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataAnalysisEndTime", dataAnalysisEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ) extends zio.aws.sagemaker.model.ScheduleConfig.ReadOnly {
    override val scheduleExpression: ScheduleExpression =
      zio.aws.sagemaker.model.primitives
        .ScheduleExpression(impl.scheduleExpression())
    override val dataAnalysisStartTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAnalysisStartTime())
      .map(value => value: String)
    override val dataAnalysisEndTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataAnalysisEndTime())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ScheduleConfig
  ): zio.aws.sagemaker.model.ScheduleConfig.ReadOnly = new Wrapper(impl)
}
