package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters._
final case class RStudioServerProDomainSettingsForUpdate(
    domainExecutionRoleArn: RoleArn,
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent,
    rStudioConnectUrl: Optional[String] = Optional.Absent,
    rStudioPackageManagerUrl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate = {
    import RStudioServerProDomainSettingsForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
      .builder()
      .domainExecutionRoleArn(
        RoleArn.unwrap(domainExecutionRoleArn): java.lang.String
      )
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .optionallyWith(rStudioConnectUrl.map(value => value: java.lang.String))(
        _.rStudioConnectUrl
      )
      .optionallyWith(
        rStudioPackageManagerUrl.map(value => value: java.lang.String)
      )(_.rStudioPackageManagerUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate
      .wrap(buildAwsValue())
}
object RStudioServerProDomainSettingsForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate =
      zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate(
        domainExecutionRoleArn,
        defaultResourceSpec.map(value => value.asEditable),
        rStudioConnectUrl.map(value => value),
        rStudioPackageManagerUrl.map(value => value)
      )
    def domainExecutionRoleArn: RoleArn
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def rStudioConnectUrl: Optional[String]
    def rStudioPackageManagerUrl: Optional[String]
    def getDomainExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRoleArn)
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
    def getRStudioConnectUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rStudioConnectUrl", rStudioConnectUrl)
    def getRStudioPackageManagerUrl: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("rStudioPackageManagerUrl", rStudioPackageManagerUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ) extends zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly {
    override val domainExecutionRoleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.domainExecutionRoleArn())
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val rStudioConnectUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rStudioConnectUrl())
      .map(value => value: String)
    override val rStudioPackageManagerUrl: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rStudioPackageManagerUrl())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProDomainSettingsForUpdate
  ): zio.aws.sagemaker.model.RStudioServerProDomainSettingsForUpdate.ReadOnly =
    new Wrapper(impl)
}
