package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RStudioServerProAppSettings(
    accessStatus: Optional[
      zio.aws.sagemaker.model.RStudioServerProAccessStatus
    ] = Optional.Absent,
    userGroup: Optional[zio.aws.sagemaker.model.RStudioServerProUserGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings = {
    import RStudioServerProAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
      .builder()
      .optionallyWith(accessStatus.map(value => value.unwrap))(_.accessStatus)
      .optionallyWith(userGroup.map(value => value.unwrap))(_.userGroup)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProAppSettings.wrap(buildAwsValue())
}
object RStudioServerProAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RStudioServerProAppSettings =
      zio.aws.sagemaker.model.RStudioServerProAppSettings(
        accessStatus.map(value => value),
        userGroup.map(value => value)
      )
    def accessStatus
        : Optional[zio.aws.sagemaker.model.RStudioServerProAccessStatus]
    def userGroup: Optional[zio.aws.sagemaker.model.RStudioServerProUserGroup]
    def getAccessStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProAccessStatus
    ] = AwsError.unwrapOptionField("accessStatus", accessStatus)
    def getUserGroup: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProUserGroup
    ] = AwsError.unwrapOptionField("userGroup", userGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ) extends zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly {
    override val accessStatus
        : Optional[zio.aws.sagemaker.model.RStudioServerProAccessStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessStatus())
        .map(value =>
          zio.aws.sagemaker.model.RStudioServerProAccessStatus.wrap(value)
        )
    override val userGroup
        : Optional[zio.aws.sagemaker.model.RStudioServerProUserGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userGroup())
        .map(value =>
          zio.aws.sagemaker.model.RStudioServerProUserGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ): zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly = new Wrapper(
    impl
  )
}
