package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OnlineStoreConfigUpdate(
    ttlDuration: Optional[zio.aws.sagemaker.model.TtlDuration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate = {
    import OnlineStoreConfigUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate
      .builder()
      .optionallyWith(ttlDuration.map(value => value.buildAwsValue()))(
        _.ttlDuration
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly =
    zio.aws.sagemaker.model.OnlineStoreConfigUpdate.wrap(buildAwsValue())
}
object OnlineStoreConfigUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OnlineStoreConfigUpdate =
      zio.aws.sagemaker.model
        .OnlineStoreConfigUpdate(ttlDuration.map(value => value.asEditable))
    def ttlDuration: Optional[zio.aws.sagemaker.model.TtlDuration.ReadOnly]
    def getTtlDuration
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TtlDuration.ReadOnly] =
      AwsError.unwrapOptionField("ttlDuration", ttlDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate
  ) extends zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly {
    override val ttlDuration
        : Optional[zio.aws.sagemaker.model.TtlDuration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ttlDuration())
        .map(value => zio.aws.sagemaker.model.TtlDuration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfigUpdate
  ): zio.aws.sagemaker.model.OnlineStoreConfigUpdate.ReadOnly = new Wrapper(
    impl
  )
}
