package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelPackageGroupStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus
}
object ModelPackageGroupStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus
  ): zio.aws.sagemaker.model.ModelPackageGroupStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.PENDING
  }
  case object InProgress
      extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.FAILED
  }
  case object Deleting extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.DELETING
  }
  case object DeleteFailed
      extends zio.aws.sagemaker.model.ModelPackageGroupStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupStatus.DELETE_FAILED
  }
}
