package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  UserProfileName,
  DomainId,
  MaxResults,
  NextToken
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUserProfilesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.UserProfileSortKey] =
      Optional.Absent,
    domainIdEquals: Optional[DomainId] = Optional.Absent,
    userProfileNameContains: Optional[UserProfileName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest = {
    import ListUserProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(
        domainIdEquals.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.domainIdEquals)
      .optionallyWith(
        userProfileNameContains.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileNameContains)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListUserProfilesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListUserProfilesRequest.wrap(buildAwsValue())
}
object ListUserProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListUserProfilesRequest =
      zio.aws.sagemaker.model.ListUserProfilesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        domainIdEquals.map(value => value),
        userProfileNameContains.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def sortBy: Optional[zio.aws.sagemaker.model.UserProfileSortKey]
    def domainIdEquals: Optional[DomainId]
    def userProfileNameContains: Optional[UserProfileName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserProfileSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getDomainIdEquals: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("domainIdEquals", domainIdEquals)
    def getUserProfileNameContains: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField(
        "userProfileNameContains",
        userProfileNameContains
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest
  ) extends zio.aws.sagemaker.model.ListUserProfilesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.UserProfileSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.UserProfileSortKey.wrap(value))
    override val domainIdEquals: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIdEquals())
      .map(value => zio.aws.sagemaker.model.primitives.DomainId(value))
    override val userProfileNameContains: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileNameContains())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest
  ): zio.aws.sagemaker.model.ListUserProfilesRequest.ReadOnly = new Wrapper(
    impl
  )
}
