package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KendraSettings(
    status: Optional[zio.aws.sagemaker.model.FeatureStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.KendraSettings = {
    import KendraSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.KendraSettings
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.KendraSettings.ReadOnly =
    zio.aws.sagemaker.model.KendraSettings.wrap(buildAwsValue())
}
object KendraSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.KendraSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.KendraSettings =
      zio.aws.sagemaker.model.KendraSettings(status.map(value => value))
    def status: Optional[zio.aws.sagemaker.model.FeatureStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.KendraSettings
  ) extends zio.aws.sagemaker.model.KendraSettings.ReadOnly {
    override val status: Optional[zio.aws.sagemaker.model.FeatureStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.FeatureStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.KendraSettings
  ): zio.aws.sagemaker.model.KendraSettings.ReadOnly = new Wrapper(impl)
}
