package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.S3OutputPath
import scala.jdk.CollectionConverters._
final case class HubS3StorageConfig(
    s3OutputPath: Optional[S3OutputPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig = {
    import HubS3StorageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig
      .builder()
      .optionallyWith(
        s3OutputPath.map(value => S3OutputPath.unwrap(value): java.lang.String)
      )(_.s3OutputPath)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly =
    zio.aws.sagemaker.model.HubS3StorageConfig.wrap(buildAwsValue())
}
object HubS3StorageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HubS3StorageConfig =
      zio.aws.sagemaker.model
        .HubS3StorageConfig(s3OutputPath.map(value => value))
    def s3OutputPath: Optional[S3OutputPath]
    def getS3OutputPath: ZIO[Any, AwsError, S3OutputPath] =
      AwsError.unwrapOptionField("s3OutputPath", s3OutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig
  ) extends zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly {
    override val s3OutputPath: Optional[S3OutputPath] = zio.aws.core.internal
      .optionalFromNullable(impl.s3OutputPath())
      .map(value => zio.aws.sagemaker.model.primitives.S3OutputPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HubS3StorageConfig
  ): zio.aws.sagemaker.model.HubS3StorageConfig.ReadOnly = new Wrapper(impl)
}
