package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  FeatureGroupArn,
  LastModifiedTime,
  FeatureGroupName,
  FeatureName,
  FeatureDescription
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FeatureMetadata(
    featureGroupArn: Optional[FeatureGroupArn] = Optional.Absent,
    featureGroupName: Optional[FeatureGroupName] = Optional.Absent,
    featureName: Optional[FeatureName] = Optional.Absent,
    featureType: Optional[zio.aws.sagemaker.model.FeatureType] =
      Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    description: Optional[FeatureDescription] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.sagemaker.model.FeatureParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureMetadata = {
    import FeatureMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureMetadata
      .builder()
      .optionallyWith(
        featureGroupArn.map(value =>
          FeatureGroupArn.unwrap(value): java.lang.String
        )
      )(_.featureGroupArn)
      .optionallyWith(
        featureGroupName.map(value =>
          FeatureGroupName.unwrap(value): java.lang.String
        )
      )(_.featureGroupName)
      .optionallyWith(
        featureName.map(value => FeatureName.unwrap(value): java.lang.String)
      )(_.featureName)
      .optionallyWith(featureType.map(value => value.unwrap))(_.featureType)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        description.map(value =>
          FeatureDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureMetadata.ReadOnly =
    zio.aws.sagemaker.model.FeatureMetadata.wrap(buildAwsValue())
}
object FeatureMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureMetadata =
      zio.aws.sagemaker.model.FeatureMetadata(
        featureGroupArn.map(value => value),
        featureGroupName.map(value => value),
        featureName.map(value => value),
        featureType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureGroupArn: Optional[FeatureGroupArn]
    def featureGroupName: Optional[FeatureGroupName]
    def featureName: Optional[FeatureName]
    def featureType: Optional[zio.aws.sagemaker.model.FeatureType]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def description: Optional[FeatureDescription]
    def parameters
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]]
    def getFeatureGroupArn: ZIO[Any, AwsError, FeatureGroupArn] =
      AwsError.unwrapOptionField("featureGroupArn", featureGroupArn)
    def getFeatureGroupName: ZIO[Any, AwsError, FeatureGroupName] =
      AwsError.unwrapOptionField("featureGroupName", featureGroupName)
    def getFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getFeatureType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureType] =
      AwsError.unwrapOptionField("featureType", featureType)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getDescription: ZIO[Any, AwsError, FeatureDescription] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureMetadata
  ) extends zio.aws.sagemaker.model.FeatureMetadata.ReadOnly {
    override val featureGroupArn: Optional[FeatureGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.FeatureGroupArn(value))
    override val featureGroupName: Optional[FeatureGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureGroupName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureGroupName(value)
        )
    override val featureName: Optional[FeatureName] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val featureType: Optional[zio.aws.sagemaker.model.FeatureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureType())
        .map(value => zio.aws.sagemaker.model.FeatureType.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val description: Optional[FeatureDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.FeatureDescription(value)
        )
    override val parameters
        : Optional[List[zio.aws.sagemaker.model.FeatureParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureMetadata
  ): zio.aws.sagemaker.model.FeatureMetadata.ReadOnly = new Wrapper(impl)
}
