package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait Direction {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.Direction
}
object Direction {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.Direction
  ): zio.aws.sagemaker.model.Direction = value match {
    case software.amazon.awssdk.services.sagemaker.model.Direction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.Direction.BOTH =>
      val r = Both
      r
    case software.amazon.awssdk.services.sagemaker.model.Direction.ASCENDANTS =>
      val r = Ascendants
      r
    case software.amazon.awssdk.services.sagemaker.model.Direction.DESCENDANTS =>
      val r = Descendants
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.Direction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Direction =
      software.amazon.awssdk.services.sagemaker.model.Direction.UNKNOWN_TO_SDK_VERSION
  }
  case object Both extends zio.aws.sagemaker.model.Direction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Direction =
      software.amazon.awssdk.services.sagemaker.model.Direction.BOTH
  }
  case object Ascendants extends zio.aws.sagemaker.model.Direction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Direction =
      software.amazon.awssdk.services.sagemaker.model.Direction.ASCENDANTS
  }
  case object Descendants extends zio.aws.sagemaker.model.Direction {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Direction =
      software.amazon.awssdk.services.sagemaker.model.Direction.DESCENDANTS
  }
}
