package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.AppImageConfigName
import scala.jdk.CollectionConverters._
final case class DescribeAppImageConfigRequest(
    appImageConfigName: AppImageConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest = {
    import DescribeAppImageConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest
      .builder()
      .appImageConfigName(
        AppImageConfigName.unwrap(appImageConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeAppImageConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeAppImageConfigRequest.wrap(buildAwsValue())
}
object DescribeAppImageConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAppImageConfigRequest =
      zio.aws.sagemaker.model.DescribeAppImageConfigRequest(appImageConfigName)
    def appImageConfigName: AppImageConfigName
    def getAppImageConfigName: ZIO[Any, Nothing, AppImageConfigName] =
      ZIO.succeed(appImageConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest
  ) extends zio.aws.sagemaker.model.DescribeAppImageConfigRequest.ReadOnly {
    override val appImageConfigName: AppImageConfigName =
      zio.aws.sagemaker.model.primitives
        .AppImageConfigName(impl.appImageConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest
  ): zio.aws.sagemaker.model.DescribeAppImageConfigRequest.ReadOnly =
    new Wrapper(impl)
}
