package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.HubArn
import scala.jdk.CollectionConverters._
final case class CreateHubResponse(hubArn: HubArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateHubResponse = {
    import CreateHubResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateHubResponse
      .builder()
      .hubArn(HubArn.unwrap(hubArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateHubResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateHubResponse.wrap(buildAwsValue())
}
object CreateHubResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateHubResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateHubResponse =
      zio.aws.sagemaker.model.CreateHubResponse(hubArn)
    def hubArn: HubArn
    def getHubArn: ZIO[Any, Nothing, HubArn] = ZIO.succeed(hubArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHubResponse
  ) extends zio.aws.sagemaker.model.CreateHubResponse.ReadOnly {
    override val hubArn: HubArn =
      zio.aws.sagemaker.model.primitives.HubArn(impl.hubArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHubResponse
  ): zio.aws.sagemaker.model.CreateHubResponse.ReadOnly = new Wrapper(impl)
}
