package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CollectionType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CollectionType
}
object CollectionType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CollectionType
  ): zio.aws.sagemaker.model.CollectionType = value match {
    case software.amazon.awssdk.services.sagemaker.model.CollectionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CollectionType.LIST =>
      val r = List
      r
    case software.amazon.awssdk.services.sagemaker.model.CollectionType.SET =>
      val r = Set
      r
    case software.amazon.awssdk.services.sagemaker.model.CollectionType.VECTOR =>
      val r = Vector
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CollectionType =
      software.amazon.awssdk.services.sagemaker.model.CollectionType.UNKNOWN_TO_SDK_VERSION
  }
  case object List extends zio.aws.sagemaker.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CollectionType =
      software.amazon.awssdk.services.sagemaker.model.CollectionType.LIST
  }
  case object Set extends zio.aws.sagemaker.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CollectionType =
      software.amazon.awssdk.services.sagemaker.model.CollectionType.SET
  }
  case object Vector extends zio.aws.sagemaker.model.CollectionType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CollectionType =
      software.amazon.awssdk.services.sagemaker.model.CollectionType.VECTOR
  }
}
