package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CodeRepositorySortOrder {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder
}
object CodeRepositorySortOrder {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder
  ): zio.aws.sagemaker.model.CodeRepositorySortOrder = value match {
    case software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.ASCENDING =>
      val r = Ascending
      r
    case software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.DESCENDING =>
      val r = Descending
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CodeRepositorySortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder =
      software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object Ascending
      extends zio.aws.sagemaker.model.CodeRepositorySortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder =
      software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.ASCENDING
  }
  case object Descending
      extends zio.aws.sagemaker.model.CodeRepositorySortOrder {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder =
      software.amazon.awssdk.services.sagemaker.model.CodeRepositorySortOrder.DESCENDING
  }
}
