package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait CaptureMode {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CaptureMode
}
object CaptureMode {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CaptureMode
  ): zio.aws.sagemaker.model.CaptureMode = value match {
    case software.amazon.awssdk.services.sagemaker.model.CaptureMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CaptureMode.INPUT =>
      val r = Input
      r
    case software.amazon.awssdk.services.sagemaker.model.CaptureMode.OUTPUT =>
      val r = Output
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.CaptureMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureMode =
      software.amazon.awssdk.services.sagemaker.model.CaptureMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Input extends zio.aws.sagemaker.model.CaptureMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureMode =
      software.amazon.awssdk.services.sagemaker.model.CaptureMode.INPUT
  }
  case object Output extends zio.aws.sagemaker.model.CaptureMode {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CaptureMode =
      software.amazon.awssdk.services.sagemaker.model.CaptureMode.OUTPUT
  }
}
