package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  UsersPerStep,
  NumberOfSteps,
  TrafficDurationInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Stairs(
    durationInSeconds: Optional[TrafficDurationInSeconds] = Optional.Absent,
    numberOfSteps: Optional[NumberOfSteps] = Optional.Absent,
    usersPerStep: Optional[UsersPerStep] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Stairs = {
    import Stairs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Stairs
      .builder()
      .optionallyWith(
        durationInSeconds.map(value =>
          TrafficDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .optionallyWith(
        numberOfSteps.map(value => NumberOfSteps.unwrap(value): Integer)
      )(_.numberOfSteps)
      .optionallyWith(
        usersPerStep.map(value => UsersPerStep.unwrap(value): Integer)
      )(_.usersPerStep)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Stairs.ReadOnly =
    zio.aws.sagemaker.model.Stairs.wrap(buildAwsValue())
}
object Stairs {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Stairs] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Stairs =
      zio.aws.sagemaker.model.Stairs(
        durationInSeconds.map(value => value),
        numberOfSteps.map(value => value),
        usersPerStep.map(value => value)
      )
    def durationInSeconds: Optional[TrafficDurationInSeconds]
    def numberOfSteps: Optional[NumberOfSteps]
    def usersPerStep: Optional[UsersPerStep]
    def getDurationInSeconds: ZIO[Any, AwsError, TrafficDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
    def getNumberOfSteps: ZIO[Any, AwsError, NumberOfSteps] =
      AwsError.unwrapOptionField("numberOfSteps", numberOfSteps)
    def getUsersPerStep: ZIO[Any, AwsError, UsersPerStep] =
      AwsError.unwrapOptionField("usersPerStep", usersPerStep)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Stairs
  ) extends zio.aws.sagemaker.model.Stairs.ReadOnly {
    override val durationInSeconds: Optional[TrafficDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrafficDurationInSeconds(value)
        )
    override val numberOfSteps: Optional[NumberOfSteps] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfSteps())
      .map(value => zio.aws.sagemaker.model.primitives.NumberOfSteps(value))
    override val usersPerStep: Optional[UsersPerStep] = zio.aws.core.internal
      .optionalFromNullable(impl.usersPerStep())
      .map(value => zio.aws.sagemaker.model.primitives.UsersPerStep(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Stairs
  ): zio.aws.sagemaker.model.Stairs.ReadOnly = new Wrapper(impl)
}
