package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class SelectiveExecutionConfig(
    sourcePipelineExecutionArn: Optional[PipelineExecutionArn] =
      Optional.Absent,
    selectedSteps: Iterable[zio.aws.sagemaker.model.SelectedStep]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig = {
    import SelectiveExecutionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
      .builder()
      .optionallyWith(
        sourcePipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.sourcePipelineExecutionArn)
      .selectedSteps(selectedSteps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly =
    zio.aws.sagemaker.model.SelectiveExecutionConfig.wrap(buildAwsValue())
}
object SelectiveExecutionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SelectiveExecutionConfig =
      zio.aws.sagemaker.model.SelectiveExecutionConfig(
        sourcePipelineExecutionArn.map(value => value),
        selectedSteps.map { item =>
          item.asEditable
        }
      )
    def sourcePipelineExecutionArn: Optional[PipelineExecutionArn]
    def selectedSteps: List[zio.aws.sagemaker.model.SelectedStep.ReadOnly]
    def getSourcePipelineExecutionArn
        : ZIO[Any, AwsError, PipelineExecutionArn] = AwsError.unwrapOptionField(
      "sourcePipelineExecutionArn",
      sourcePipelineExecutionArn
    )
    def getSelectedSteps: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.SelectedStep.ReadOnly
    ]] = ZIO.succeed(selectedSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ) extends zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly {
    override val sourcePipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
    override val selectedSteps
        : List[zio.aws.sagemaker.model.SelectedStep.ReadOnly] = impl
      .selectedSteps()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.SelectedStep.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SelectiveExecutionConfig
  ): zio.aws.sagemaker.model.SelectiveExecutionConfig.ReadOnly = new Wrapper(
    impl
  )
}
