package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ResourceCatalogSortBy {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy
}
object ResourceCatalogSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy
  ): zio.aws.sagemaker.model.ResourceCatalogSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ResourceCatalogSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy =
      software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object CreationTime
      extends zio.aws.sagemaker.model.ResourceCatalogSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy =
      software.amazon.awssdk.services.sagemaker.model.ResourceCatalogSortBy.CREATION_TIME
  }
}
