package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  ResourceCatalogDescription,
  ResourceCatalogName,
  ResourceCatalogArn
}
import scala.jdk.CollectionConverters._
final case class ResourceCatalog(
    resourceCatalogArn: ResourceCatalogArn,
    resourceCatalogName: ResourceCatalogName,
    description: ResourceCatalogDescription,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceCatalog = {
    import ResourceCatalog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceCatalog
      .builder()
      .resourceCatalogArn(
        ResourceCatalogArn.unwrap(resourceCatalogArn): java.lang.String
      )
      .resourceCatalogName(
        ResourceCatalogName.unwrap(resourceCatalogName): java.lang.String
      )
      .description(
        ResourceCatalogDescription.unwrap(description): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceCatalog.ReadOnly =
    zio.aws.sagemaker.model.ResourceCatalog.wrap(buildAwsValue())
}
object ResourceCatalog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceCatalog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceCatalog =
      zio.aws.sagemaker.model.ResourceCatalog(
        resourceCatalogArn,
        resourceCatalogName,
        description,
        creationTime
      )
    def resourceCatalogArn: ResourceCatalogArn
    def resourceCatalogName: ResourceCatalogName
    def description: ResourceCatalogDescription
    def creationTime: Timestamp
    def getResourceCatalogArn: ZIO[Any, Nothing, ResourceCatalogArn] =
      ZIO.succeed(resourceCatalogArn)
    def getResourceCatalogName: ZIO[Any, Nothing, ResourceCatalogName] =
      ZIO.succeed(resourceCatalogName)
    def getDescription: ZIO[Any, Nothing, ResourceCatalogDescription] =
      ZIO.succeed(description)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceCatalog
  ) extends zio.aws.sagemaker.model.ResourceCatalog.ReadOnly {
    override val resourceCatalogArn: ResourceCatalogArn =
      zio.aws.sagemaker.model.primitives
        .ResourceCatalogArn(impl.resourceCatalogArn())
    override val resourceCatalogName: ResourceCatalogName =
      zio.aws.sagemaker.model.primitives
        .ResourceCatalogName(impl.resourceCatalogName())
    override val description: ResourceCatalogDescription =
      zio.aws.sagemaker.model.primitives
        .ResourceCatalogDescription(impl.description())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceCatalog
  ): zio.aws.sagemaker.model.ResourceCatalog.ReadOnly = new Wrapper(impl)
}
