package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait HyperParameterTuningAllocationStrategy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy
}
object HyperParameterTuningAllocationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy
  ): zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy =
    value match {
      case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy.PRIORITIZED =>
        val r = Prioritized
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object Prioritized
      extends zio.aws.sagemaker.model.HyperParameterTuningAllocationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningAllocationStrategy.PRIORITIZED
  }
}
