package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait HubContentSortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HubContentSortBy
}
object HubContentSortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HubContentSortBy
  ): zio.aws.sagemaker.model.HubContentSortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.HUB_CONTENT_NAME =>
      val r = HubContentName
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.HUB_CONTENT_STATUS =>
      val r = HubContentStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HubContentSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object HubContentName extends zio.aws.sagemaker.model.HubContentSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.HUB_CONTENT_NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.HubContentSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.CREATION_TIME
  }
  case object HubContentStatus
      extends zio.aws.sagemaker.model.HubContentSortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentSortBy =
      software.amazon.awssdk.services.sagemaker.model.HubContentSortBy.HUB_CONTENT_STATUS
  }
}
