package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{FeatureName, FeatureGroupNameOrArn}
import scala.jdk.CollectionConverters._
final case class DescribeFeatureMetadataRequest(
    featureGroupName: FeatureGroupNameOrArn,
    featureName: FeatureName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest = {
    import DescribeFeatureMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest
      .builder()
      .featureGroupName(
        FeatureGroupNameOrArn.unwrap(featureGroupName): java.lang.String
      )
      .featureName(FeatureName.unwrap(featureName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFeatureMetadataRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeFeatureMetadataRequest.wrap(buildAwsValue())
}
object DescribeFeatureMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFeatureMetadataRequest =
      zio.aws.sagemaker.model
        .DescribeFeatureMetadataRequest(featureGroupName, featureName)
    def featureGroupName: FeatureGroupNameOrArn
    def featureName: FeatureName
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupNameOrArn] =
      ZIO.succeed(featureGroupName)
    def getFeatureName: ZIO[Any, Nothing, FeatureName] =
      ZIO.succeed(featureName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest
  ) extends zio.aws.sagemaker.model.DescribeFeatureMetadataRequest.ReadOnly {
    override val featureGroupName: FeatureGroupNameOrArn =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupNameOrArn(impl.featureGroupName())
    override val featureName: FeatureName =
      zio.aws.sagemaker.model.primitives.FeatureName(impl.featureName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest
  ): zio.aws.sagemaker.model.DescribeFeatureMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
