package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  SpaceName,
  AppName,
  UserProfileName,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class CreateAppRequest(
    domainId: DomainId,
    userProfileName: Optional[UserProfileName] = Optional.Absent,
    appType: zio.aws.sagemaker.model.AppType,
    appName: AppName,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent,
    resourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent,
    spaceName: Optional[SpaceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAppRequest = {
    import CreateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        userProfileName.map(value =>
          UserProfileName.unwrap(value): java.lang.String
        )
      )(_.userProfileName)
      .appType(appType.unwrap)
      .appName(AppName.unwrap(appName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(resourceSpec.map(value => value.buildAwsValue()))(
        _.resourceSpec
      )
      .optionallyWith(
        spaceName.map(value => SpaceName.unwrap(value): java.lang.String)
      )(_.spaceName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAppRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateAppRequest.wrap(buildAwsValue())
}
object CreateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAppRequest =
      zio.aws.sagemaker.model.CreateAppRequest(
        domainId,
        userProfileName.map(value => value),
        appType,
        appName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceSpec.map(value => value.asEditable),
        spaceName.map(value => value)
      )
    def domainId: DomainId
    def userProfileName: Optional[UserProfileName]
    def appType: zio.aws.sagemaker.model.AppType
    def appName: AppName
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def resourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def spaceName: Optional[SpaceName]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, AwsError, UserProfileName] =
      AwsError.unwrapOptionField("userProfileName", userProfileName)
    def getAppType: ZIO[Any, Nothing, zio.aws.sagemaker.model.AppType] =
      ZIO.succeed(appType)
    def getAppName: ZIO[Any, Nothing, AppName] = ZIO.succeed(appName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("resourceSpec", resourceSpec)
    def getSpaceName: ZIO[Any, AwsError, SpaceName] =
      AwsError.unwrapOptionField("spaceName", spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ) extends zio.aws.sagemaker.model.CreateAppRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: Optional[UserProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userProfileName())
        .map(value => zio.aws.sagemaker.model.primitives.UserProfileName(value))
    override val appType: zio.aws.sagemaker.model.AppType =
      zio.aws.sagemaker.model.AppType.wrap(impl.appType())
    override val appName: AppName =
      zio.aws.sagemaker.model.primitives.AppName(impl.appName())
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val resourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val spaceName: Optional[SpaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.sagemaker.model.primitives.SpaceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ): zio.aws.sagemaker.model.CreateAppRequest.ReadOnly = new Wrapper(impl)
}
