package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RepositoryUrl
import scala.jdk.CollectionConverters._
final case class CodeRepository(repositoryUrl: RepositoryUrl) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CodeRepository = {
    import CodeRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CodeRepository
      .builder()
      .repositoryUrl(RepositoryUrl.unwrap(repositoryUrl): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CodeRepository.ReadOnly =
    zio.aws.sagemaker.model.CodeRepository.wrap(buildAwsValue())
}
object CodeRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CodeRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CodeRepository =
      zio.aws.sagemaker.model.CodeRepository(repositoryUrl)
    def repositoryUrl: RepositoryUrl
    def getRepositoryUrl: ZIO[Any, Nothing, RepositoryUrl] =
      ZIO.succeed(repositoryUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CodeRepository
  ) extends zio.aws.sagemaker.model.CodeRepository.ReadOnly {
    override val repositoryUrl: RepositoryUrl =
      zio.aws.sagemaker.model.primitives.RepositoryUrl(impl.repositoryUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CodeRepository
  ): zio.aws.sagemaker.model.CodeRepository.ReadOnly = new Wrapper(impl)
}
