package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AsyncNotificationTopicTypes {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes
}
object AsyncNotificationTopicTypes {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes
  ): zio.aws.sagemaker.model.AsyncNotificationTopicTypes = value match {
    case software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.SUCCESS_NOTIFICATION_TOPIC =>
      val r = SUCCESS_NOTIFICATION_TOPIC
      r
    case software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.ERROR_NOTIFICATION_TOPIC =>
      val r = ERROR_NOTIFICATION_TOPIC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AsyncNotificationTopicTypes {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes =
      software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS_NOTIFICATION_TOPIC
      extends zio.aws.sagemaker.model.AsyncNotificationTopicTypes {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes =
      software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.SUCCESS_NOTIFICATION_TOPIC
  }
  case object ERROR_NOTIFICATION_TOPIC
      extends zio.aws.sagemaker.model.AsyncNotificationTopicTypes {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes =
      software.amazon.awssdk.services.sagemaker.model.AsyncNotificationTopicTypes.ERROR_NOTIFICATION_TOPIC
  }
}
