package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SecurityGroupId, RoleArn}
import scala.jdk.CollectionConverters._
final case class UserSettings(
    executionRole: Optional[RoleArn] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    sharingSettings: Optional[zio.aws.sagemaker.model.SharingSettings] =
      Optional.Absent,
    jupyterServerAppSettings: Optional[
      zio.aws.sagemaker.model.JupyterServerAppSettings
    ] = Optional.Absent,
    kernelGatewayAppSettings: Optional[
      zio.aws.sagemaker.model.KernelGatewayAppSettings
    ] = Optional.Absent,
    tensorBoardAppSettings: Optional[
      zio.aws.sagemaker.model.TensorBoardAppSettings
    ] = Optional.Absent,
    rStudioServerProAppSettings: Optional[
      zio.aws.sagemaker.model.RStudioServerProAppSettings
    ] = Optional.Absent,
    rSessionAppSettings: Optional[zio.aws.sagemaker.model.RSessionAppSettings] =
      Optional.Absent,
    canvasAppSettings: Optional[zio.aws.sagemaker.model.CanvasAppSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UserSettings = {
    import UserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UserSettings
      .builder()
      .optionallyWith(
        executionRole.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRole)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sharingSettings.map(value => value.buildAwsValue()))(
        _.sharingSettings
      )
      .optionallyWith(
        jupyterServerAppSettings.map(value => value.buildAwsValue())
      )(_.jupyterServerAppSettings)
      .optionallyWith(
        kernelGatewayAppSettings.map(value => value.buildAwsValue())
      )(_.kernelGatewayAppSettings)
      .optionallyWith(
        tensorBoardAppSettings.map(value => value.buildAwsValue())
      )(_.tensorBoardAppSettings)
      .optionallyWith(
        rStudioServerProAppSettings.map(value => value.buildAwsValue())
      )(_.rStudioServerProAppSettings)
      .optionallyWith(rSessionAppSettings.map(value => value.buildAwsValue()))(
        _.rSessionAppSettings
      )
      .optionallyWith(canvasAppSettings.map(value => value.buildAwsValue()))(
        _.canvasAppSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UserSettings.ReadOnly =
    zio.aws.sagemaker.model.UserSettings.wrap(buildAwsValue())
}
object UserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UserSettings =
      zio.aws.sagemaker.model.UserSettings(
        executionRole.map(value => value),
        securityGroups.map(value => value),
        sharingSettings.map(value => value.asEditable),
        jupyterServerAppSettings.map(value => value.asEditable),
        kernelGatewayAppSettings.map(value => value.asEditable),
        tensorBoardAppSettings.map(value => value.asEditable),
        rStudioServerProAppSettings.map(value => value.asEditable),
        rSessionAppSettings.map(value => value.asEditable),
        canvasAppSettings.map(value => value.asEditable)
      )
    def executionRole: Optional[RoleArn]
    def securityGroups: Optional[List[SecurityGroupId]]
    def sharingSettings
        : Optional[zio.aws.sagemaker.model.SharingSettings.ReadOnly]
    def jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly]
    def kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly]
    def tensorBoardAppSettings
        : Optional[zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly]
    def rStudioServerProAppSettings
        : Optional[zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly]
    def rSessionAppSettings
        : Optional[zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly]
    def canvasAppSettings
        : Optional[zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly]
    def getExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRole", executionRole)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSharingSettings
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.SharingSettings.ReadOnly] =
      AwsError.unwrapOptionField("sharingSettings", sharingSettings)
    def getJupyterServerAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jupyterServerAppSettings",
      jupyterServerAppSettings
    )
    def getKernelGatewayAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kernelGatewayAppSettings",
      kernelGatewayAppSettings
    )
    def getTensorBoardAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tensorBoardAppSettings",
      tensorBoardAppSettings
    )
    def getRStudioServerProAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rStudioServerProAppSettings",
      rStudioServerProAppSettings
    )
    def getRSessionAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField("rSessionAppSettings", rSessionAppSettings)
    def getCanvasAppSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly
    ] = AwsError.unwrapOptionField("canvasAppSettings", canvasAppSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UserSettings
  ) extends zio.aws.sagemaker.model.UserSettings.ReadOnly {
    override val executionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRole())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val sharingSettings
        : Optional[zio.aws.sagemaker.model.SharingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharingSettings())
        .map(value => zio.aws.sagemaker.model.SharingSettings.wrap(value))
    override val jupyterServerAppSettings
        : Optional[zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jupyterServerAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(value)
        )
    override val kernelGatewayAppSettings
        : Optional[zio.aws.sagemaker.model.KernelGatewayAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernelGatewayAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.KernelGatewayAppSettings.wrap(value)
        )
    override val tensorBoardAppSettings
        : Optional[zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tensorBoardAppSettings())
        .map(value =>
          zio.aws.sagemaker.model.TensorBoardAppSettings.wrap(value)
        )
    override val rStudioServerProAppSettings: Optional[
      zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rStudioServerProAppSettings())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProAppSettings.wrap(value)
      )
    override val rSessionAppSettings
        : Optional[zio.aws.sagemaker.model.RSessionAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rSessionAppSettings())
        .map(value => zio.aws.sagemaker.model.RSessionAppSettings.wrap(value))
    override val canvasAppSettings
        : Optional[zio.aws.sagemaker.model.CanvasAppSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canvasAppSettings())
        .map(value => zio.aws.sagemaker.model.CanvasAppSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UserSettings
  ): zio.aws.sagemaker.model.UserSettings.ReadOnly = new Wrapper(impl)
}
