package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{KmsKeyId, TransformInstanceCount}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TransformResources(
    instanceType: zio.aws.sagemaker.model.TransformInstanceType,
    instanceCount: TransformInstanceCount,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformResources = {
    import TransformResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformResources
      .builder()
      .instanceType(instanceType.unwrap)
      .instanceCount(TransformInstanceCount.unwrap(instanceCount): Integer)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformResources.ReadOnly =
    zio.aws.sagemaker.model.TransformResources.wrap(buildAwsValue())
}
object TransformResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformResources =
      zio.aws.sagemaker.model.TransformResources(
        instanceType,
        instanceCount,
        volumeKmsKeyId.map(value => value)
      )
    def instanceType: zio.aws.sagemaker.model.TransformInstanceType
    def instanceCount: TransformInstanceCount
    def volumeKmsKeyId: Optional[KmsKeyId]
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformInstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, TransformInstanceCount] =
      ZIO.succeed(instanceCount)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformResources
  ) extends zio.aws.sagemaker.model.TransformResources.ReadOnly {
    override val instanceType: zio.aws.sagemaker.model.TransformInstanceType =
      zio.aws.sagemaker.model.TransformInstanceType.wrap(impl.instanceType())
    override val instanceCount: TransformInstanceCount =
      zio.aws.sagemaker.model.primitives
        .TransformInstanceCount(impl.instanceCount())
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformResources
  ): zio.aws.sagemaker.model.TransformResources.ReadOnly = new Wrapper(impl)
}
