package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.BaseModelName
import scala.jdk.CollectionConverters._
final case class TextGenerationJobConfig(
    completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria
    ] = Optional.Absent,
    baseModelName: Optional[BaseModelName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig = {
    import TextGenerationJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig
      .builder()
      .optionallyWith(completionCriteria.map(value => value.buildAwsValue()))(
        _.completionCriteria
      )
      .optionallyWith(
        baseModelName.map(value =>
          BaseModelName.unwrap(value): java.lang.String
        )
      )(_.baseModelName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TextGenerationJobConfig.ReadOnly =
    zio.aws.sagemaker.model.TextGenerationJobConfig.wrap(buildAwsValue())
}
object TextGenerationJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TextGenerationJobConfig =
      zio.aws.sagemaker.model.TextGenerationJobConfig(
        completionCriteria.map(value => value.asEditable),
        baseModelName.map(value => value)
      )
    def completionCriteria
        : Optional[zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly]
    def baseModelName: Optional[BaseModelName]
    def getCompletionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("completionCriteria", completionCriteria)
    def getBaseModelName: ZIO[Any, AwsError, BaseModelName] =
      AwsError.unwrapOptionField("baseModelName", baseModelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig
  ) extends zio.aws.sagemaker.model.TextGenerationJobConfig.ReadOnly {
    override val completionCriteria: Optional[
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.completionCriteria())
      .map(value =>
        zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(value)
      )
    override val baseModelName: Optional[BaseModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.baseModelName())
      .map(value => zio.aws.sagemaker.model.primitives.BaseModelName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TextGenerationJobConfig
  ): zio.aws.sagemaker.model.TextGenerationJobConfig.ReadOnly = new Wrapper(
    impl
  )
}
