package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  LastModifiedTime,
  NotebookInstanceArn,
  NotebookInstanceUrl,
  NotebookInstanceName,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class NotebookInstanceSummary(
    notebookInstanceName: NotebookInstanceName,
    notebookInstanceArn: NotebookInstanceArn,
    notebookInstanceStatus: Optional[
      zio.aws.sagemaker.model.NotebookInstanceStatus
    ] = Optional.Absent,
    url: Optional[NotebookInstanceUrl] = Optional.Absent,
    instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lastModifiedTime: Optional[LastModifiedTime] = Optional.Absent,
    notebookInstanceLifecycleConfigName: Optional[
      NotebookInstanceLifecycleConfigName
    ] = Optional.Absent,
    defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] = Optional.Absent,
    additionalCodeRepositories: Optional[Iterable[CodeRepositoryNameOrUrl]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary = {
    import NotebookInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
      .builder()
      .notebookInstanceName(
        NotebookInstanceName.unwrap(notebookInstanceName): java.lang.String
      )
      .notebookInstanceArn(
        NotebookInstanceArn.unwrap(notebookInstanceArn): java.lang.String
      )
      .optionallyWith(notebookInstanceStatus.map(value => value.unwrap))(
        _.notebookInstanceStatus
      )
      .optionallyWith(
        url.map(value => NotebookInstanceUrl.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => LastModifiedTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        notebookInstanceLifecycleConfigName.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigName)
      .optionallyWith(
        defaultCodeRepository.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepository)
      .optionallyWith(
        additionalCodeRepositories.map(value =>
          value.map { item =>
            CodeRepositoryNameOrUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalCodeRepositories)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly =
    zio.aws.sagemaker.model.NotebookInstanceSummary.wrap(buildAwsValue())
}
object NotebookInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.NotebookInstanceSummary =
      zio.aws.sagemaker.model.NotebookInstanceSummary(
        notebookInstanceName,
        notebookInstanceArn,
        notebookInstanceStatus.map(value => value),
        url.map(value => value),
        instanceType.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        notebookInstanceLifecycleConfigName.map(value => value),
        defaultCodeRepository.map(value => value),
        additionalCodeRepositories.map(value => value)
      )
    def notebookInstanceName: NotebookInstanceName
    def notebookInstanceArn: NotebookInstanceArn
    def notebookInstanceStatus
        : Optional[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def url: Optional[NotebookInstanceUrl]
    def instanceType: Optional[zio.aws.sagemaker.model.InstanceType]
    def creationTime: Optional[CreationTime]
    def lastModifiedTime: Optional[LastModifiedTime]
    def notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName]
    def defaultCodeRepository: Optional[CodeRepositoryNameOrUrl]
    def additionalCodeRepositories: Optional[List[CodeRepositoryNameOrUrl]]
    def getNotebookInstanceName: ZIO[Any, Nothing, NotebookInstanceName] =
      ZIO.succeed(notebookInstanceName)
    def getNotebookInstanceArn: ZIO[Any, Nothing, NotebookInstanceArn] =
      ZIO.succeed(notebookInstanceArn)
    def getNotebookInstanceStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField(
        "notebookInstanceStatus",
        notebookInstanceStatus
      )
    def getUrl: ZIO[Any, AwsError, NotebookInstanceUrl] =
      AwsError.unwrapOptionField("url", url)
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigName",
        notebookInstanceLifecycleConfigName
      )
    def getDefaultCodeRepository: ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField("defaultCodeRepository", defaultCodeRepository)
    def getAdditionalCodeRepositories
        : ZIO[Any, AwsError, List[CodeRepositoryNameOrUrl]] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositories",
        additionalCodeRepositories
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ) extends zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly {
    override val notebookInstanceName: NotebookInstanceName =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceName(impl.notebookInstanceName())
    override val notebookInstanceArn: NotebookInstanceArn =
      zio.aws.sagemaker.model.primitives
        .NotebookInstanceArn(impl.notebookInstanceArn())
    override val notebookInstanceStatus
        : Optional[zio.aws.sagemaker.model.NotebookInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookInstanceStatus())
        .map(value =>
          zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value)
        )
    override val url: Optional[NotebookInstanceUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceUrl(value)
      )
    override val instanceType: Optional[zio.aws.sagemaker.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.sagemaker.model.InstanceType.wrap(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTime: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val notebookInstanceLifecycleConfigName
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigName())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val defaultCodeRepository: Optional[CodeRepositoryNameOrUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultCodeRepository())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
        )
    override val additionalCodeRepositories
        : Optional[List[CodeRepositoryNameOrUrl]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalCodeRepositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary
  ): zio.aws.sagemaker.model.NotebookInstanceSummary.ReadOnly = new Wrapper(
    impl
  )
}
