package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ArtifactDigest
import scala.jdk.CollectionConverters._
final case class ModelDigests(
    artifactDigest: Optional[ArtifactDigest] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelDigests = {
    import ModelDigests.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelDigests
      .builder()
      .optionallyWith(
        artifactDigest.map(value =>
          ArtifactDigest.unwrap(value): java.lang.String
        )
      )(_.artifactDigest)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelDigests.ReadOnly =
    zio.aws.sagemaker.model.ModelDigests.wrap(buildAwsValue())
}
object ModelDigests {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelDigests
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelDigests =
      zio.aws.sagemaker.model.ModelDigests(artifactDigest.map(value => value))
    def artifactDigest: Optional[ArtifactDigest]
    def getArtifactDigest: ZIO[Any, AwsError, ArtifactDigest] =
      AwsError.unwrapOptionField("artifactDigest", artifactDigest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDigests
  ) extends zio.aws.sagemaker.model.ModelDigests.ReadOnly {
    override val artifactDigest: Optional[ArtifactDigest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactDigest())
        .map(value => zio.aws.sagemaker.model.primitives.ArtifactDigest(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelDigests
  ): zio.aws.sagemaker.model.ModelDigests.ReadOnly = new Wrapper(impl)
}
