package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MetricSpecification(
    predefined: Optional[
      zio.aws.sagemaker.model.PredefinedMetricSpecification
    ] = Optional.Absent,
    customized: Optional[
      zio.aws.sagemaker.model.CustomizedMetricSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricSpecification = {
    import MetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricSpecification
      .builder()
      .optionallyWith(predefined.map(value => value.buildAwsValue()))(
        _.predefined
      )
      .optionallyWith(customized.map(value => value.buildAwsValue()))(
        _.customized
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricSpecification.ReadOnly =
    zio.aws.sagemaker.model.MetricSpecification.wrap(buildAwsValue())
}
object MetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricSpecification =
      zio.aws.sagemaker.model.MetricSpecification(
        predefined.map(value => value.asEditable),
        customized.map(value => value.asEditable)
      )
    def predefined: Optional[
      zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly
    ]
    def customized: Optional[
      zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly
    ]
    def getPredefined: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("predefined", predefined)
    def getCustomized: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("customized", customized)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricSpecification
  ) extends zio.aws.sagemaker.model.MetricSpecification.ReadOnly {
    override val predefined: Optional[
      zio.aws.sagemaker.model.PredefinedMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predefined())
      .map(value =>
        zio.aws.sagemaker.model.PredefinedMetricSpecification.wrap(value)
      )
    override val customized: Optional[
      zio.aws.sagemaker.model.CustomizedMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customized())
      .map(value =>
        zio.aws.sagemaker.model.CustomizedMetricSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricSpecification
  ): zio.aws.sagemaker.model.MetricSpecification.ReadOnly = new Wrapper(impl)
}
