package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{MetricRegex, MetricName}
import scala.jdk.CollectionConverters._
final case class MetricDefinition(name: MetricName, regex: MetricRegex) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricDefinition = {
    import MetricDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricDefinition
      .builder()
      .name(MetricName.unwrap(name): java.lang.String)
      .regex(MetricRegex.unwrap(regex): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricDefinition.ReadOnly =
    zio.aws.sagemaker.model.MetricDefinition.wrap(buildAwsValue())
}
object MetricDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricDefinition =
      zio.aws.sagemaker.model.MetricDefinition(name, regex)
    def name: MetricName
    def regex: MetricRegex
    def getName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(name)
    def getRegex: ZIO[Any, Nothing, MetricRegex] = ZIO.succeed(regex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricDefinition
  ) extends zio.aws.sagemaker.model.MetricDefinition.ReadOnly {
    override val name: MetricName =
      zio.aws.sagemaker.model.primitives.MetricName(impl.name())
    override val regex: MetricRegex =
      zio.aws.sagemaker.model.primitives.MetricRegex(impl.regex())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricDefinition
  ): zio.aws.sagemaker.model.MetricDefinition.ReadOnly = new Wrapper(impl)
}
