package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  LastModifiedTime,
  NotebookInstanceNameContains,
  CodeRepositoryContains,
  MaxResults,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListNotebookInstancesRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.NotebookInstanceSortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.NotebookInstanceSortOrder] =
      Optional.Absent,
    nameContains: Optional[NotebookInstanceNameContains] = Optional.Absent,
    creationTimeBefore: Optional[CreationTime] = Optional.Absent,
    creationTimeAfter: Optional[CreationTime] = Optional.Absent,
    lastModifiedTimeBefore: Optional[LastModifiedTime] = Optional.Absent,
    lastModifiedTimeAfter: Optional[LastModifiedTime] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.NotebookInstanceStatus] =
      Optional.Absent,
    notebookInstanceLifecycleConfigNameContains: Optional[
      NotebookInstanceLifecycleConfigName
    ] = Optional.Absent,
    defaultCodeRepositoryContains: Optional[CodeRepositoryContains] =
      Optional.Absent,
    additionalCodeRepositoryEquals: Optional[CodeRepositoryNameOrUrl] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest = {
    import ListNotebookInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value =>
          NotebookInstanceNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        notebookInstanceLifecycleConfigNameContains.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigNameContains)
      .optionallyWith(
        defaultCodeRepositoryContains.map(value =>
          CodeRepositoryContains.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepositoryContains)
      .optionallyWith(
        additionalCodeRepositoryEquals.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.additionalCodeRepositoryEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstancesRequest.wrap(buildAwsValue())
}
object ListNotebookInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListNotebookInstancesRequest =
      zio.aws.sagemaker.model.ListNotebookInstancesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        statusEquals.map(value => value),
        notebookInstanceLifecycleConfigNameContains.map(value => value),
        defaultCodeRepositoryContains.map(value => value),
        additionalCodeRepositoryEquals.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortBy: Optional[zio.aws.sagemaker.model.NotebookInstanceSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.NotebookInstanceSortOrder]
    def nameContains: Optional[NotebookInstanceNameContains]
    def creationTimeBefore: Optional[CreationTime]
    def creationTimeAfter: Optional[CreationTime]
    def lastModifiedTimeBefore: Optional[LastModifiedTime]
    def lastModifiedTimeAfter: Optional[LastModifiedTime]
    def statusEquals: Optional[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def notebookInstanceLifecycleConfigNameContains
        : Optional[NotebookInstanceLifecycleConfigName]
    def defaultCodeRepositoryContains: Optional[CodeRepositoryContains]
    def additionalCodeRepositoryEquals: Optional[CodeRepositoryNameOrUrl]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceSortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains: ZIO[Any, AwsError, NotebookInstanceNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNotebookInstanceLifecycleConfigNameContains
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigNameContains",
        notebookInstanceLifecycleConfigNameContains
      )
    def getDefaultCodeRepositoryContains
        : ZIO[Any, AwsError, CodeRepositoryContains] =
      AwsError.unwrapOptionField(
        "defaultCodeRepositoryContains",
        defaultCodeRepositoryContains
      )
    def getAdditionalCodeRepositoryEquals
        : ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositoryEquals",
        additionalCodeRepositoryEquals
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ) extends zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.NotebookInstanceSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.NotebookInstanceSortKey.wrap(value)
        )
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.NotebookInstanceSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value =>
          zio.aws.sagemaker.model.NotebookInstanceSortOrder.wrap(value)
        )
    override val nameContains: Optional[NotebookInstanceNameContains] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.NotebookInstanceNameContains(value)
        )
    override val creationTimeBefore: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeBefore())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeAfter: Optional[CreationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimeAfter())
        .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeBefore: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeBefore())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val lastModifiedTimeAfter: Optional[LastModifiedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimeAfter())
        .map(value =>
          zio.aws.sagemaker.model.primitives.LastModifiedTime(value)
        )
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.NotebookInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value =>
          zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value)
        )
    override val notebookInstanceLifecycleConfigNameContains
        : Optional[NotebookInstanceLifecycleConfigName] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigNameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val defaultCodeRepositoryContains
        : Optional[CodeRepositoryContains] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultCodeRepositoryContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryContains(value)
      )
    override val additionalCodeRepositoryEquals
        : Optional[CodeRepositoryNameOrUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalCodeRepositoryEquals())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ): zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
