package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListModelCardVersionsResponse(
    modelCardVersionSummaryList: Iterable[
      zio.aws.sagemaker.model.ModelCardVersionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse = {
    import ListModelCardVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse
      .builder()
      .modelCardVersionSummaryList(modelCardVersionSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelCardVersionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListModelCardVersionsResponse.wrap(buildAwsValue())
}
object ListModelCardVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelCardVersionsResponse =
      zio.aws.sagemaker.model.ListModelCardVersionsResponse(
        modelCardVersionSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def modelCardVersionSummaryList
        : List[zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getModelCardVersionSummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly
    ]] = ZIO.succeed(modelCardVersionSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse
  ) extends zio.aws.sagemaker.model.ListModelCardVersionsResponse.ReadOnly {
    override val modelCardVersionSummaryList
        : List[zio.aws.sagemaker.model.ModelCardVersionSummary.ReadOnly] = impl
      .modelCardVersionSummaryList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ModelCardVersionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse
  ): zio.aws.sagemaker.model.ListModelCardVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
